<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_category()
    {
        return $this->belongsTo('App\Models\Product\ProductCategory', 'product_category_id');
    }

    public function products_variationss()
    {
        return $this->hasMany('ProductVariation', 'product_id');
    }

    public function abstracts()
    {
        return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
    }

}